/*  This code will read in a data file, and create intake and
/*  summary variables.  It DOES NOT correct entries, nor impute
/*  values for missing portion size variables;

DATA LONG;
  INFILE IN;
        INPUT
                   APPL             $     0001-0003
                   SER              $     0004-0009
                   BAT              $     0010-0012
                   SCNMM            $     0013-0014
                   SCNDD            $     0015-0016
                   SCNYY            $     0017-0018
                   DOC              $     0019-0021
                   EDIT             $     0022-0024
                   FLAGS            $     0025-0040
                   LITHO_ID         $     0041-0050
                   WESID            $     0051-0060
                   Q1               $     0061
                   Q1A              $     0062
                   Q2               $     0063
                   Q2A              $     0064
                   Q3               $     0065
                   Q3A              $     0066
                   Q4               $     0067
                   Q4A              $     0068
                   Q5               $     0069
                   Q5A              $     0070
                   Q6               $     0071
                   Q6A1             $     0072
                   Q6A2             $     0073
                   Q7               $     0074
                   Q7A              $     0075
                   Q8               $     0076
                   Q8A1             $     0077
                   Q8A2             $     0078
                   Q9               $     0079
                   Q9A              $     0080
                   Q10              $     0081
                   Q10A1            $     0082
                   Q10A2            $     0083
                   Q11              $     0084
                   Q11A             $     0085
                   Q12              $     0086
                   Q12A             $     0087
                   Q13              $     0088
                   Q13A             $     0089
                   Q14              $     0090
 ;


PROC FORMAT;

                VALUE $Q1____F
                  '0' = 'NEVER           '
                  '1' = '1-3 TIMES LAST M'
                  '2' = '1-2 TIMES PER WE'
                  '3' = '3-4 TIMES PER WE'
                  '4' = '5-6 TIMES PER WE'
                  '5' = '1 TIME PER DAY  '
                  '6' = '2 TIMES PER DAY '
                  '7' = '3 TIMES PER DAY '
                  '8' = '4 TIMES PER DAY '
                  '9' = '5 OR MORE TIMES '
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q1A___F
                  '0' = 'LESS THAN 3/4 CU'
                  '1' = '3/4 TO 1 1/4 CUP'
                  '2' = '1 1/4 TO 2 CUPS '
                  '3' = 'MORE THAN 2 CUPS'
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q2A___F
                  '0' = 'ABOUT 1/2 CUP   '
                  '1' = 'ABOUT 1 CUP     '
                  '2' = 'ABOUT 2 CUPS    '
                  '3' = 'MORE THAN 2 CUPS'
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q3A___F
                  '0' = 'SMALL ORDER OR L'
                  '1' = 'MEDIUM ORDER (AB'
                  '2' = 'LARGE ORDER (ABO'
                  '3' = 'SUPER SIZE ORDER'
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q4A___F
                  '0' = '1 SMALL POTATO O'
                  '1' = '1 MEDIUM POTATO '
                  '2' = '1 LARGE POTATO ('
                  '3' = '2 MEDIUM POTATOE'
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q5A___F
                  '0' = 'LESS THAN 1/2 CU'
                  '1' = '1/2 TO 1 CUP    '
                  '2' = '1 TO 1 1/2 CUPS '
                  '3' = 'MORE THAN 1 1/2 '
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q6____F
                  '0' = 'NEVER           '
                  '1' = '1-3 DAYS LAST MO'
                  '2' = '1-2 DAYS PER WEE'
                  '3' = '3-4 DAYS PER WEE'
                  '4' = '5-6 DAYS PER WEE'
                  '5' = 'EVERY DAY       '
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q6A1__F
                  '0' = 'LESS THAN 1 MEDI'
                  '1' = '1 MEDIUM FRUIT  '
                  '2' = '2 MEDIUM FRUITS '
                  '3' = 'MORE THAN 2 MEDI'
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q6A2__F
                  '0' = 'LESS THAN 1/2 CU'
                  '1' = 'ABOUT 1/2 CUP   '
                  '2' = 'ABOUT 1 CUP     '
                  '3' = 'MORE THAN 1 CUP '
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q7A___F
                  '0' = 'LESS THAN 1/2 CU'
                  '1' = '1/2 TO 1 CUP    '
                  '2' = '1 TO 2 CUPS     '
                  '3' = 'MORE THAN 2 CUPS'
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q12A__F
                  '0' = 'ABOUT 1/4 CUP   '
                  '1' = 'ABOUT 1/2 CUP   '
                  '2' = 'ABOUT 1 CUP     '
                  '3' = 'MORE THAN 1 CUP '
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;
                VALUE $Q13A__F
                  '0' = 'LESS THAN 1 CUP '
                  '1' = '1 TO 2 CUPS     '
                  '2' = '2 TO 3 CUPS     '
                  '3' = 'MORE THAN 3 CUPS'
                  'M' = 'MISSING         '
                  'E' = 'ERROR           '
                ;


*FORMAT
                Q1                $Q1____F.
                Q1A               $Q1A___F.
                Q2                $Q1____F.
                Q2A               $Q2A___F.
                Q3                $Q1____F.
                Q3A               $Q3A___F.
                Q4                $Q1____F.
                Q4A               $Q4A___F.
                Q5                $Q1____F.
                Q5A               $Q5A___F.
                Q6                $Q6____F.
                Q6A1              $Q6A1__F.
                Q6A2              $Q6A2__F.
                Q7                $Q1____F.
                Q7A               $Q7A___F.
                Q8                $Q1____F.
                Q8A1              $Q6A1__F.
                Q8A2              $Q6A2__F.
                Q9                $Q6____F.
                Q9A               $Q7A___F.
                Q10               $Q6____F.
                Q10A1             $Q6A1__F.
                Q10A2             $Q6A2__F.
                Q11               $Q6____F.
                Q11A              $Q7A___F.
                Q12               $Q1____F.
                Q12A              $Q12A__F.
                Q13               $Q1____F.
                Q13A              $Q13A__F.
                Q14               $Q1____F.
                ;


LABEL
          APPL     = '-->APPLICATION NUMBER'
          SER      = '-->SERIAL NUMBER'
          BAT      = '-->BATCH NUMBER'
          SCNMM    = '-->SCANNED MONTH (MM)'
          SCNDD    = '-->SCANNED DAY (DD)'
          SCNYY    = '-->SCANNED YEAR (YY)'
          DOC      = '-->DOCUMENT NUMBER'
          EDIT     = '-->EDIT FLAGS'
          FLAGS    = '-->SCANNING FLAGS'
          LITHO_ID = '-->LITHOCODE ID NUMBER'
          Wesid    = '-->STUDY/BARCODE ID NUMBER'
          Q1       = '-->OVER THE LAST MONTH, HOW MANY TIMES'
          Q1A      = '-->EACH TIME YOU DRANK 100% JUICE, HOW'
          Q2       = '-->OVER THE LAST MONTH, HOW OFTEN DID'
          Q2A      = '-->EACH TIME YOU ATE LETTUCE SALAD, HOW'
          Q3       = '-->OVER THE LAST MONTH, HOW OFTEN DID'
          Q3A      = '-->EACH TIME YOU ATE FRENCH FRIES OR'
          Q4       = '-->OVER THE LAST MONTH, HOW OFTEN DID'
          Q4A      = '-->EACH TIME YOU ATE THESE POTATOES, HOW'
          Q5       = '-->OVER THE LAST MONTH, HOW OFTEN DID'
          Q5A      = '-->EACH TIME YOU ATE THESE BEANS, HOW'
          Q6       = '-->ON HOW MANY DAYS DID YOU EAT FRUIT'
          Q6A1     = '-->WHEN YOU ATE FRUIT IN THE MORNING,'
          Q6A2     = '-->WHEN YOU ATE FRUIT IN THE MORNING,'
          Q7       = '-->THINK ABOUT ALL THE FOODS YOU ATE AT'
          Q7A      = '-->WHEN YOU ATE VEGETABLES IN THE'
          Q8       = '-->ON HOW MANY DAYS DID YOU EAT FRUIT AT'
          Q8A1     = '-->WHEN YOU ATE FRUIT AT LUNCHTIME OR'
          Q8A2     = '-->WHEN YOU ATE FRUIT AT LUNCHTIME OR'
          Q9       = '-->ON HOW MANY DAYS DID YOU EAT'
          Q9A      = '-->WHEN YOU ATE VEGETABLES AT LUNCHTIME'
          Q10      = '-->ON HOW MANY DAYS DID YOU EAT FRUIT AT'
          Q10A1    = '-->WHEN YOU ATE FRUIT AT SUPPERTIME OR'
          Q10A2    = '-->WHEN YOU ATE FRUIT AT SUPPERTIME OR'
          Q11      = '-->ON HOW MANY DAYS DID YOU EAT'
          Q11A     = '-->WHEN YOU ATE VEGETABLES AT SUPPERTIME'
          Q12      = '-->OVER THE LAST MONTH, HOW OFTEN DID'
          Q12A     = '-->EACH TIME YOU ATE TOMATO SAUCE, HOW'
          Q13      = '-->OVER THE LAST MONTH, HOW OFTEN DID'
          Q13A     = '-->EACH TIME YOU ATE VEGETABLE SOUP, HOW'
          Q14      = '-->OVER THE LAST MONTH, HOW OFTEN DID'
 ;


DATA LONG;
  SET LONG;


  %MACRO FREQN (INC,OUTN);
   IF &INC='0' THEN &OUTN=0;
    ELSE IF &INC='1' THEN &OUTN=.067;
    ELSE IF &INC='2' THEN &OUTN=.214;
    ELSE IF &INC='3' THEN &OUTN=.5;
    ELSE IF &INC='4' THEN &OUTN=.786;
    ELSE IF &INC='5' THEN &OUTN=1;
    ELSE IF &INC='6' THEN &OUTN=2;
    ELSE IF &INC='7' THEN &OUTN=3;
    ELSE IF &INC='8' THEN &OUTN=4;
    ELSE IF &INC='9' THEN &OUTN=5;
  %MEND FREQN;

  %MACRO FREQL (INC,OUTN);
   IF &INC='0' THEN &OUTN=0;
    ELSE IF &INC='1' THEN &OUTN=.067;
    ELSE IF &INC='2' THEN &OUTN=.214;
    ELSE IF &INC='3' THEN &OUTN=.5;
    ELSE IF &INC='4' THEN &OUTN=.786;
    ELSE IF &INC='5' THEN &OUTN=1;
  %MEND FREQL;

 %FREQN(Q1,Q1N);
  IF Q1A='0' THEN Q1AN=0.5;
    ELSE IF Q1A='1' THEN Q1AN=1.0;
    ELSE IF Q1A='2' THEN Q1AN=1.625;
    ELSE IF Q1A='3' THEN Q1AN=2.5;
    ELSE IF Q1N=0 THEN Q1AN=0;
  JUICE=Q1N*Q1AN;

 %FREQN(Q2,Q2N);
  IF Q2A='0' THEN Q2AN=0.25;
    ELSE IF Q2A='1' THEN Q2AN=0.5;
    ELSE IF Q2A='2' THEN Q2AN=1.0;
    ELSE IF Q2A='3' THEN Q2AN=1.5;
    ELSE IF Q2N=0 THEN Q2AN=0;
  LSALAD=Q2N*Q2AN;

 %FREQN(Q3,Q3N);
  IF Q3A='0' THEN Q3AN=0.2;
    ELSE IF Q3A='1' THEN Q3AN=0.5;
    ELSE IF Q3A='2' THEN Q3AN=0.75;
    ELSE IF Q3A='3' THEN Q3AN=1.3;
    ELSE IF Q3N=0 THEN Q3AN=0;
  FRFRY=Q3N*Q3AN;

 %FREQN(Q4,Q4N);
  IF Q4A='0' THEN Q4AN=0.25;
    ELSE IF Q4A='1' THEN Q4AN=0.75;
    ELSE IF Q4A='2' THEN Q4AN=1.2;
    ELSE IF Q4A='3' THEN Q4AN=2.0;
    ELSE IF Q4N=0 THEN Q4AN=0;
  WHPOT=Q4N*Q4AN;

 %FREQN(Q5,Q5N);
  IF Q5A='0' THEN Q5AN=0.25;
    ELSE IF Q5A='1' THEN Q5AN=0.75;
    ELSE IF Q5A='2' THEN Q5AN=1.25;
    ELSE IF Q5A='3' THEN Q5AN=2.0;
    ELSE IF Q5N=0 THEN Q5AN=0;
  DRBEAN=Q5N*Q5AN;

 %FREQN(Q12,Q12N);
  IF Q12A='0' THEN Q12AN=0.25;
    ELSE IF Q12A='1' THEN Q12AN=0.5;
    ELSE IF Q12A='2' THEN Q12AN=1.0;
    ELSE IF Q12A='3' THEN Q12AN=1.5;
    ELSE IF Q12N=0 THEN Q12AN=0;
  TOMSAUCE=Q12N*Q12AN;

 %FREQN(Q13,Q13N);
  IF Q13A='0' THEN Q13AN=0.3;
    ELSE IF Q13A='1' THEN Q13AN=1.0;
    ELSE IF Q13A='2' THEN Q13AN=1.6;
    ELSE IF Q13A='3' THEN Q13AN=2.25;
    ELSE IF Q13N=0 THEN Q13AN=0;
  VEGSOUP=Q13N*Q13AN;

 %FREQL(Q6,Q6N);
  IF Q6A1='0' THEN Q6A1N=0.25;
    ELSE IF Q6A1='1' THEN Q6A1N=0.5;
    ELSE IF Q6A1='2' THEN Q6A1N=1.0;
    ELSE IF Q6A1='3' THEN Q6A1N=1.5;
    ELSE IF Q6N=0 THEN Q6A1N=0;
  FRTAMA=Q6N*Q6A1N;
  IF Q6A2='0' THEN Q6A2N=0.25;
    ELSE IF Q6A2='1' THEN Q6A2N=0.5;
    ELSE IF Q6A2='2' THEN Q6A2N=1.0;
    ELSE IF Q6A2='3' THEN Q6A2N=1.5;
    ELSE IF Q6N=0 THEN Q6A2N=0;
  FRTAMB=Q6N*Q6A2N;
  FRTAM=MEAN(FRTAMA,FRTAMB);

 %FREQL(Q8,Q8N);
  IF Q8A1='0' THEN Q8A1N=0.25;
    ELSE IF Q8A1='1' THEN Q8A1N=0.5;
    ELSE IF Q8A1='2' THEN Q8A1N=1.0;
    ELSE IF Q8A1='3' THEN Q8A1N=1.5;
    ELSE IF Q8N=0 THEN Q8A1N=0;
  FRTNNA=Q8N*Q8A1N;
  IF Q8A2='0' THEN Q8A2N=0.25;
    ELSE IF Q8A2='1' THEN Q8A2N=0.5;
    ELSE IF Q8A2='2' THEN Q8A2N=1.0;
    ELSE IF Q8A2='3' THEN Q8A2N=1.5;
    ELSE IF Q8N=0 THEN Q8A2N=0;
  FRTNNB=Q8N*Q8A2N;
  FRTNN=MEAN(FRTNNA,FRTNNB);

 %FREQL(Q10,Q10N);
  IF Q10A1='0' THEN Q10A1N=0.25;
    ELSE IF Q10A1='1' THEN Q10A1N=0.5;
    ELSE IF Q10A1='2' THEN Q10A1N=1.0;
    ELSE IF Q10A1='3' THEN Q10A1N=1.5;
    ELSE IF Q10N=0 THEN Q10A1N=0;
  FRTPMA=Q10N*Q10A1N;
  IF Q10A2='0' THEN Q10A2N=0.25;
    ELSE IF Q10A2='1' THEN Q10A2N=0.5;
    ELSE IF Q10A2='2' THEN Q10A2N=1.0;
    ELSE IF Q10A2='3' THEN Q10A2N=1.5;
    ELSE IF Q10N=0 THEN Q10A2N=0;
  FRTPMB=Q10N*Q10A2N;
  FRTPM=MEAN(FRTPMA,FRTPMB);

  FRUIT=SUM(FRTAM,FRTNN,FRTPM);

 %FREQL(Q7,Q7N);
  IF Q7A='0' THEN Q7AN=0.25;
    ELSE IF Q7A='1' THEN Q7AN=0.75;
    ELSE IF Q7A='2' THEN Q7AN=1.5;
    ELSE IF Q7A='3' THEN Q7AN=2.25;
    ELSE IF Q7N=0 THEN Q7AN=0;
  OVEGAM=Q7N*Q7AN;

 %FREQL(Q9,Q9N);
  IF Q9A='0' THEN Q9AN=0.25;
    ELSE IF Q9A='1' THEN Q9AN=0.75;
    ELSE IF Q9A='2' THEN Q9AN=1.5;
    ELSE IF Q9A='3' THEN Q9AN=2.25;
    ELSE IF Q9N=0 THEN Q9AN=0;
  OVEGNN=Q9N*Q9AN;

 %FREQL(Q11,Q11N);
  IF Q11A='0' THEN Q11AN=0.25;
    ELSE IF Q11A='1' THEN Q11AN=0.75;
    ELSE IF Q11A='2' THEN Q11AN=1.5;
    ELSE IF Q11A='3' THEN Q11AN=2.25;
    ELSE IF Q11N=0 THEN Q11AN=0;
  OVEGPM=Q11N*Q11AN;

  OTHVEG=SUM(OVEGAM,OVEGNN,OVEGPM);

  FRTVEG=SUM(JUICE,FRUIT,LSALAD,FRFRY,WHPOT,DRBEAN,OTHVEG,TOMSAUCE,
    VEGSOUP);
